<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_currencypal
 *
 * @copyright   Copyright (C) 2025 CurrencyPal. All rights reserved.
 * @license     GNU General Public License version 2 or later
 *
 * Compatible with Joomla 2.5, 3.x, 4.x, 5.x, and 6.x
 */

defined('_JEXEC') or die;

// Load helper class
require_once __DIR__ . '/helper.php';

// Get module parameters
$widgetId   = $params->get('widget_id', '');
$baseUrl    = ModCurrencyPalHelper::getBaseUrl($params);
$maxWidth   = ModCurrencyPalHelper::sanitizeDimension($params->get('max_width', '100%'), '100%');
$maxHeight  = ModCurrencyPalHelper::sanitizeDimension($params->get('max_height', 'auto'), 'auto');
$embedUrl   = ModCurrencyPalHelper::getEmbedUrl($params);
$moduleId   = $module->id;

// Don't render if no widget ID
if (empty($widgetId)) {
    return;
}

// Get layout path (compatible with Joomla 2.5+)
if (class_exists('Joomla\CMS\Helper\ModuleHelper')) {
    $layoutPath = \Joomla\CMS\Helper\ModuleHelper::getLayoutPath('mod_currencypal', $params->get('layout', 'default'));
} else {
    $layoutPath = JModuleHelper::getLayoutPath('mod_currencypal', $params->get('layout', 'default'));
}

require $layoutPath;
