<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_currencypal
 *
 * @copyright   Copyright (C) 2025 CurrencyPal. All rights reserved.
 * @license     GNU General Public License version 2 or later
 *
 * Compatible with Joomla 2.5, 3.x, 4.x, 5.x, and 6.x
 */

defined('_JEXEC') or die;

$containerStyle = ModCurrencyPalHelper::getContainerStyle($maxWidth);
$iframeStyle = ModCurrencyPalHelper::getIframeStyle($maxHeight);
$iframeTitle = ModCurrencyPalHelper::translate('MOD_CURRENCYPAL_IFRAME_TITLE');
$iframeId = 'currencypal-iframe-' . (int) $moduleId;
$widgetId = htmlspecialchars($params->get('widget_id', ''), ENT_QUOTES, 'UTF-8');
?>
<div class="mod-currencypal <?php echo htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8'); ?>"
     id="currencypal-widget-<?php echo (int) $moduleId; ?>">
    <div class="currencypal-widget-container" style="<?php echo $containerStyle; ?>">
        <iframe
            id="<?php echo $iframeId; ?>"
            src="<?php echo $embedUrl; ?>"
            style="<?php echo $iframeStyle; ?>"
            loading="lazy"
            title="<?php echo htmlspecialchars($iframeTitle, ENT_QUOTES, 'UTF-8'); ?>">
        </iframe>
    </div>
</div>
<script>
(function() {
    window.addEventListener('message', function(event) {
        if (event.data && event.data.type === 'currencypal-resize' && event.data.widgetId === '<?php echo $widgetId; ?>') {
            var iframe = document.getElementById('<?php echo $iframeId; ?>');
            if (iframe && event.data.height) {
                iframe.style.height = event.data.height + 'px';
            }
        }
    });
})();
</script>
