(function(blocks, element, components, editor, i18n) {
    var el = element.createElement;
    var TextControl = components.TextControl;
    var PanelBody = components.PanelBody;
    var InspectorControls = editor.InspectorControls;
    var useBlockProps = editor.useBlockProps;

    var baseUrl = (window.currencypalWidget && window.currencypalWidget.baseUrl) || 'https://currencypal.net';

    blocks.registerBlockType('currencypal/widget', {
        title: i18n.__('CurrencyPal Widget', 'currencypal-widget'),
        description: i18n.__('Embed a CurrencyPal currency exchange rate widget.', 'currencypal-widget'),
        icon: 'money-alt',
        category: 'embed',
        keywords: [
            i18n.__('currency', 'currencypal-widget'),
            i18n.__('exchange', 'currencypal-widget'),
            i18n.__('rates', 'currencypal-widget'),
            i18n.__('widget', 'currencypal-widget'),
        ],
        attributes: {
            widgetId: {
                type: 'string',
                default: '',
            },
            maxWidth: {
                type: 'string',
                default: '100%',
            },
            maxHeight: {
                type: 'string',
                default: 'auto',
            },
        },

        edit: function(props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;
            var blockProps = useBlockProps ? useBlockProps() : {};

            var embedUrl = attributes.widgetId
                ? baseUrl + '/widget/' + attributes.widgetId
                : '';

            var containerStyle = {
                maxWidth: attributes.maxWidth || '100%',
                width: '100%',
                margin: '0 auto',
            };

            var iframeStyle = {
                width: '100%',
                border: 'none',
                minHeight: '200px',
            };

            if (attributes.maxHeight && attributes.maxHeight !== 'auto') {
                iframeStyle.maxHeight = attributes.maxHeight;
            }

            var previewContent;
            if (attributes.widgetId) {
                previewContent = el('div', { style: containerStyle },
                    el('iframe', {
                        src: embedUrl,
                        style: iframeStyle,
                        title: i18n.__('CurrencyPal Exchange Rate Widget', 'currencypal-widget'),
                    })
                );
            } else {
                previewContent = el('div', {
                    style: {
                        padding: '40px 20px',
                        backgroundColor: '#f0f0f0',
                        textAlign: 'center',
                        border: '2px dashed #ccc',
                        borderRadius: '8px',
                    }
                },
                    el('span', {
                        className: 'dashicons dashicons-money-alt',
                        style: { fontSize: '48px', marginBottom: '10px', display: 'block' },
                    }),
                    el('p', { style: { margin: '10px 0 0', color: '#666' } },
                        i18n.__('Enter your CurrencyPal Widget ID in the block settings.', 'currencypal-widget')
                    )
                );
            }

            return el('div', blockProps,
                el(InspectorControls, {},
                    el(PanelBody, {
                        title: i18n.__('Widget Settings', 'currencypal-widget'),
                        initialOpen: true,
                    },
                        el(TextControl, {
                            label: i18n.__('Widget ID', 'currencypal-widget'),
                            help: i18n.__('Enter your CurrencyPal Widget ID (required).', 'currencypal-widget'),
                            value: attributes.widgetId,
                            onChange: function(value) {
                                setAttributes({ widgetId: value });
                            },
                        }),
                        el(TextControl, {
                            label: i18n.__('Max Width', 'currencypal-widget'),
                            help: i18n.__('e.g., 500px, 100%, 50vw', 'currencypal-widget'),
                            value: attributes.maxWidth,
                            onChange: function(value) {
                                setAttributes({ maxWidth: value });
                            },
                        }),
                        el(TextControl, {
                            label: i18n.__('Max Height', 'currencypal-widget'),
                            help: i18n.__('e.g., 400px, auto, 50vh', 'currencypal-widget'),
                            value: attributes.maxHeight,
                            onChange: function(value) {
                                setAttributes({ maxHeight: value });
                            },
                        })
                    )
                ),
                previewContent
            );
        },

        save: function() {
            return null;
        },
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.blockEditor || window.wp.editor,
    window.wp.i18n
);
